//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Data.SqlClient;
using System.Diagnostics;
using System.IO;

namespace ValidatingData
{
	/// <summary>
	/// Podsumowanie dla ValidatingDataForm.
	/// </summary>
	public class ValidatingDataForm : System.Windows.Forms.Form
	{
		private System.Data.SqlClient.SqlConnection sqlNorthwindConnection;
		private System.Windows.Forms.DataGrid employeesDataGrid;
		private System.Windows.Forms.Button loadButton;
		private ErrorProvider errorProvider;
		/// <summary>
		/// Wymagana zmienna.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public ValidatingDataForm()
		{
			//
			// Wymagane do obsugi Windows Form Designer
			//
			InitializeComponent();

			DataGridTableStyle style = new DataGridTableStyle();
			style.MappingName = "Employees";
			style.AlternatingBackColor = System.Drawing.Color.Aquamarine;
			DataGridTextBoxColumn notes = new DataGridTextBoxColumn();
			notes.HeaderText = "Notes";
			notes.MappingName = "Notes";
			notes.TextBox.Multiline = true;
			notes.TextBox.WordWrap = true;
			notes.TextBox.AutoSize = true;
			// style.GridColumnStyles.AddRange ( new DataGridColumnStyle[] { notes } );
			employeesDataGrid.TableStyles.Add(style);

		}

		/// <summary>
		/// Oczyszczenie uywanych zasobw.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Metoda wymagana do obsugi Designera - nie naley modyfikowa
		/// zawartoci tej metody przy uyciu edytora kodu.
		/// </summary>
		private void InitializeComponent()
		{
			System.Collections.Specialized.NameValueCollection configurationAppSettings = System.Configuration.ConfigurationSettings.AppSettings;
			this.sqlNorthwindConnection = new System.Data.SqlClient.SqlConnection();
			this.employeesDataGrid = new System.Windows.Forms.DataGrid();
			this.loadButton = new System.Windows.Forms.Button();
			((System.ComponentModel.ISupportInitialize)(this.employeesDataGrid)).BeginInit();
			this.SuspendLayout();
			// 
			// sqlNorthwindConnection
			// 
			this.sqlNorthwindConnection.ConnectionString = configurationAppSettings.Get("sqlConnection.ConnectionString");
			// 
			// employeesDataGrid
			// 
			this.employeesDataGrid.DataMember = "";
			this.employeesDataGrid.Location = new System.Drawing.Point(8, 8);
			this.employeesDataGrid.Name = "employeesDataGrid";
			this.employeesDataGrid.Size = new System.Drawing.Size(696, 224);
			this.employeesDataGrid.TabIndex = 0;
			// 
			// loadButton
			// 
			this.loadButton.Location = new System.Drawing.Point(8, 240);
			this.loadButton.Name = "loadButton";
			this.loadButton.TabIndex = 1;
			this.loadButton.Text = "aduj";
			this.loadButton.Click += new System.EventHandler(this.OnLoadData);
			// 
			// ValidatingDataForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(720, 273);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.loadButton,
																		  this.employeesDataGrid});
			this.Name = "ValidatingDataForm";
			this.Text = "Weryfikacja pracownikw";
			((System.ComponentModel.ISupportInitialize)(this.employeesDataGrid)).EndInit();
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// Gwny punkt wejcia dla aplikacji.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new ValidatingDataForm());
		}

		private void OnLoadData(object sender, System.EventArgs e)
		{
			errorProvider = new ErrorProvider();
			errorProvider.ContainerControl = this;
			errorProvider.BlinkRate = 200;

			string select = "SELECT EmployeeID, LastName, FirstName, Title, BirthDate, HireDate, Notes FROM Employees";
			SqlDataAdapter cmd = new SqlDataAdapter(select, sqlNorthwindConnection);
			Employees ds = new Employees();
			cmd.Fill(ds, "Employees");
			employeesDataGrid.SetDataBinding(ds, "Employees");

			errorProvider.DataSource = ds;
			errorProvider.DataMember = "Employees";

			foreach (DataRow row in (ds.EmployeesTable.Rows)) 
			{
				row.ClearErrors();
				DateTime hd = Convert.ToDateTime(row["HireDate"]);
				TimeSpan seniority = DateTime.Now - hd;
				if (seniority.TotalDays/365.25 > 9) 
				{
					row.RowError = "Czy ten pracownik powinien otrzyma podwyk?";
					row.SetColumnError("HireDate", string.Format("Ten pracownik pracuje dla nas od {0:F0} lat.", seniority.TotalDays/365.25));
				} 
			} 
		}
	}
}
